/*****************************************************************************
*  LPC82x SCT Dead Time demo program
*
*  Use SCT timer to generate a two-channel double-edge controlled PWM
*  intended for use as a complementary PWM pair with dead-time control
*****************************************************************************/

#include "board.h"

#define DC1 	  (130)
#define DC2 	  (135)
#define Period 	  (180)

void sct_fsm_init (void);


void sct_fsm_init (void)
{


	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_AUTOLIMIT_L );						                // split timers, auto limit

    Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_BIDIR_L(1));                            // configure SCT1 as BIDIR


	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, Period);							            // match on (half) PWM period
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, Period);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1, DC1);							              // match on duty cycle 1
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, DC1);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_2, DC2);						                // match on duty cycle 2
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_2, DC2);


	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, (CHIP_SCT_EVENT_T) ( SCT_EVT_0 |             // event 0 and 2 set OUT0 (blue LED)
                                                                 SCT_EVT_2 ));
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_2);                               // event 2 clears OUT0 (blue LED)

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_1, SCT_EVT_3);  			 			                    // event 3 sets OUT1 (red LED)
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_1, (CHIP_SCT_EVENT_T) ( SCT_EVT_3 |
                                                                   SCT_EVT_0 ));                // event 0 and 3 clear OUT1 (red LED)


	Chip_SCT_Output(LPC_SCT, SCT_EVT_0);                                                  // default set OUT0 and and clear OUT1

	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_ALL_STATES);			                          // event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_IOCOND_FALL		|
                                                                         SCT_COMBMODE_IO		)); // IN_0 falling edge only condition

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_ALL_STATES);			                          // event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T) (  SCT_COMBMODE_IO		  |
                                                                          SCT_IOCOND_RAISE	  ));// IN_0 rising edge only condition

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_2, ENABLE_ALL_STATES);				                              // event 2 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_2,	(CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH1	|
                                                                          SCT_COMBMODE_MATCH	));// match 1 (DC1) only condition

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_3, ENABLE_ALL_STATES);				                              // event 3 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH2	|
                                                                          SCT_COMBMODE_MATCH	)); // match 2 (DC) only condition




	LPC_SCT->STOP_L =  0x0001;

	Chip_SCT_EnableEventInt(LPC_SCT, SCT_EVT_1 );

	Chip_SCT_SetConflictResolution(LPC_SCT, 0 , 0x0F);              // toggle OUT0 and OUT1 on conflict

	NVIC_EnableIRQ(SCT_IRQn);

	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}

void SCT_IRQHandler(void)
{

	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_CLRCTR_L);								// clear the L counter

	Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_STOP_L);								// start the L counter

	LPC_SCT->EVFLAG = (1 << 1);														// clear event 1 interrupt flag
}



int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON

	Chip_SWM_Init();

	Chip_SCT_Init(LPC_SCT);											/* enable the SCT clock     */

	Chip_INMUX_SetSCTInMux(LPC_INMUX, SCT_INMUX_0, SCT_INP_IN0);

	Chip_SWM_DisableFixedPin(SWM_FIXED_ADC11);

	Chip_SWM_MovablePinAssign(SWM_SCT_OUT0_O ,16);                    // SCT_OUT0 at P0_16
	Chip_SWM_MovablePinAssign(SWM_SCT_IN0_I ,4);                      // SCT_IN0  at P0_4 used as ABORT
	Chip_SWM_MovablePinAssign(SWM_SCT_OUT1_O , 12);                   // SCT_OUT1 at P0_12




	sct_fsm_init();                                   								// Initialize SCT

    while (1)                                              							// loop forever
    {
    	__WFI();
    }
}
